unit Vis;

{ === Vis unit ===}
{Author(s): J. Frankel,  N.M. Ismail (11/16/97),               }
{           J. Crawford (1/25/98)                              }
{Version: See =History= below.                                 }
{Description: This unit is the basic structure for a WinAMP    }
{   visualization plug-in.                                     }
{Usage: To use the Vis unit, add this unit to the project and  }
{   customize the routines to your specifications.  Make sure  }
{   to not change the "TWinAMPVisHeader" and "TWinAMPVisModule"}
{   structure for they are used by WinAMP itself.              }

{ === History === }
{  Date    |  Author      | Version | Notes                    }
{  1997    | J. Frankel   |  1.01   | 1st release in VC++ code.}
{ 11/16/97 | N.M. Ismail  |  1.01d  | Converted from original  }
{          |              |         | VC++ source to Delphi2/3.}
{ 1/26/98  | J. Crawford  |  1.1    | Additional testing and   }
{          |              |         | bugfixes.  Better docs.  }
{          |              |         | Bundled original C code. }

{ === Notes === }
{ Any window that remains in foreground should pass  keystrokes}
{ to the parent (WinAMP) window, so that the user can still    }
{ control it unless escape is hit, or some option key specific }
{ to the Visulization plug-in is hit.  To store custom plug-in }
{ data or configurations use the TPlugInConfig object below.   }
{ Configuration data is stored in <dll directory>\plugin.ini   }
{ - Compiler specifics - }
{ Integers 32 bits; if you have problems change the "integer"s }
{ to "longint"s.  Structure members are normally aligned (This }
{ is set in the Project|Options|Compiler menu as "Align record }
{ fields").  Tested with Borland Delphi Desktop 2.0 under      }
{ Windows NT 4.0 Workstation and Windows 95 OSR2 using WinAMP  }
{ versions 1.666 and 1.7.                                      }

interface

uses
    Windows;

{ === Version of current module ($101 = 1.01) === }
const
     VIS_HDRVER =$101;  {WinAMP checks this (for compatibility)}

{ === Structures === }
type
  PWinAMPVisHeader =^TWinAMPVisHeader;
  PWinAMPVisModule =^TWinAMPVisModule;
  TWinAMPVisHeader =record
    Version     :integer; {VIS_HDRVER}
    Description :PChar;   {description of library}
    GetModule   :function(I :integer) :PWinAMPVisModule; cdecl;
                {Gets a module pointer based on i}
  end;
  TWinAMPVisModule =record
    Description  :PChar;   {description of module}
    hWNDParent   :HWND;    {parent window (filled in by WinAMP)}
    hDLLInstance :HINST;   {instance handle to this DLL (filled in by WinAMP)}
    sRate        :integer; {sample rate (filled in by WinAMP)}
    nCh          :integer; {number of channels (filled in by WinAMP)}
    LatencyMs    :integer; {latency from call of RenderFrame to actual drawing}
                           {(WinAMP looks at this value when getting data)}
    DelayMs      :integer; {delay between calls in milliSeconds}
    SpectrumNch  :integer; {number of channels for FFT data}
    WaveformNch  :integer; {number of channels for PCM data}
{The data is filled in according to the respective Nch entry}
    SpectrumData :array[0..1,0..575] of byte;  {0=Left;1=Right}
    WaveformData :array[0..1,0..575] of byte;  {0=Left;1=Right}
    Config       :procedure(This_Mod :PWinAMPVisModule); cdecl;
                 {configuration method}
    Init         :function(This_Mod :PWinAMPVisModule) :integer; cdecl;
                 {Create window, etc.; 0=success}
    Render       :function(This_Mod :PWinAMPVisModule) :integer; cdecl;
                 {1=Plug-in should end; 0=success}
    Quit         :procedure(This_Mod :PWinAMPVisModule); cdecl;
                 {call when done}
    UserData     :pointer; {pointer to user data (optional)}
  end;

implementation
end.
